function [Go, ino, cs, cn, ce, cw] = malla_orlada(G)
%
% [GO, ino, cs, cn, ce, cw]=malla_orlada(G)
%
% Funcion auxiliar. Recibe una matriz con indices de malla tal como los que
% genera la rutina 'NUMGRID' (que asigna indices a los nodos del dominio 
% pero no del contorno) y la devuelve 'orlada' asignando indices a los
% nodos que consituirian en contorno. Supone que se va aplicar laplaciano
% de cinco puntos. Tambien supone que los indices añadidos son mayores que
% los de la matriz G.
%
% ENTRADA
%       G matriz con los indices del dominio
%
% SALIDA
%              Go    matriz de la malla orlada
%             ino    valores de los nuevos indices
% cs, cn, ce, cw     indices correspondientes a las caras S, N, E, W
%

% operador laplaciano en forma diferencial
mc = [ 0 -1 0; -1 4 -1; 0 -1 0];
% indice maximo de la malla original
Gmax = max(max(G)); 


% Calculamos la convolucion ocn la matriz que tiene un 1 en cada 
% elemento no nulo de la matriz original. 
ma = conv2( double(G>0), mc, 'same');
ma = ma<0; % los valores negativos indican los orlados

% asignamos indices a las orlas, a partir del indice mas alto de la 
% malla original
ic = find( ma );   
mad = ones(size(ma)).*ma; % la convertimos a tipo double
Gomax = Gmax + length(ic);
ino = (Gmax+1):Gomax;
mad( ic ) = ino;

% componemos la malla resultante (sumando las orlas)
% La matriz orlada, la re-orlamos con ceros, para que sea aceptada por 
% la funcion DELSQ.
Ga = G + mad;
[mga,nga] = size(Ga);
Go = [ zeros( 1, nga+2) 
        zeros(mga,1) Ga zeros( mga, 1)
        zeros(1,nga+2)];
    

% encontramos los lados N, S, E, W    
[m,n] = size(Go);
[ jj, ii] = meshgrid(1:m, 1:n);
jj = jj.*(Go>0);
ii = ii.*(Go>0);

% filas en las que se encuentran los indices
% de la cara sur
cs = max( ii );
nc = 1:n;
nc = nc( cs >0 );
cs = cs( cs >0 );
cs = (nc-1)*m+cs;
cs = Go( cs );

% columnas en las que se encuentran los indices 
% de la cara este
ce = max( jj,[],2 );
nf = 1:m; nf = nf';
nf = nf( ce > 0 );
ce = ce( ce > 0 );
ce = (ce-1)*m + nf;
ce = Go(ce);

% filas en las que se encuentran los indices de la 
% cara norte
ii(ii<1) = m+1;
cn = min( ii );
nc = 1:n;
nc = nc( cn < (m+1));
cn = cn( cn < (m+1));
cn = (nc-1)*m+cn;
cn = Go( cn );

% columnas en las que se encuentran los indices de la 
% cara oeste
jj(jj<1) = n+1;
cw = min( jj,[],2 );
nf = 1:m; nf = nf';
nf = nf( cw < (n+1) );
cw = cw( cw < (n+1) );
cw = (cw-1)*m + nf;
cw = Go(cw);

% en mallas en angulo recto los elementos de las esquinas aparecen en dos
% contornos. Por ello, recortamos los arrays de contorno por los extremos.
cs = cs( 2:end-1 );
cn = cn( 2:end-1 );
ce = ce( 2:end-1 );
cw = cw( 2:end-1 );

